<?php


namespace App\Models\Pos\Inventory\Rules;


use function Symfony\Component\Translation\t;

trait LotRules
{
    public function createdRules(): array
    {
        return [
            'supplier_id' => 'required',
            'purchase_date' => 'required|date|date_format:Y-m-d',
            'status_id' => 'required',
            'reference_no' => 'required|unique:lots,reference_no',
            'total_amount' => 'required',

            //lot variant data
            'lotVariants.*.variant_id'=> 'required',
            'lotVariants.*.unit_quantity'=> 'required',
            'lotVariants.*.unit_price'=> 'required',
            'lotVariants.*.unit_tax_percentage'=> 'required',
            'lotVariants.*.total_unit_price'=> 'required'
        ];
    }

    public function updatedRules(): array
    {
        return [
            'supplier_id' => 'required',
            'purchase_date' => 'required|date|date_format:Y-m-d',
            'status_id' => 'required',

            'lotVariants.*.variant_id'=> 'required',
            'lotVariants.*.unit_quantity'=> 'required',
            'lotVariants.*.unit_price'=> 'required',
            'lotVariants.*.unit_tax_percentage'=> 'required',
            'lotVariants.*.total_unit_price'=> 'required',

            'reference_no' => 'required|unique:lots,reference_no,'.request()->lot->id,
        ];
    }
}