<?php

namespace App\Models\Tenant\Rules;

trait CustomerRules
{
    public function createdRules()
    {
        return [
            'first_name' => 'required',
            'tenant_id' => 'required',
            'customer_group_id' => 'required|exists:customer_groups,id',
            'email_details.*.email' => 'nullable|email',
            'address_information_details.*.name' => 'required',
            'address_information_details.*.details' => 'required',
        ];
    }

    public function updateRules()
    {
        return $this->createdRules();
    }

    public function message()
    {
        return [
            'email_details.*.email.email' => __t('email_must_be_a_valid_email_address'),
            'address_information_details.*.name.required' => __t('title_field_is_required'),
            'address_information_details.*.details.required' => __t('details_field_is_required'),
        ];
    }
}