<?php

namespace Database\Seeders\Auth;

use App\Models\Core\Auth\Role;
use Database\Seeders\Traits\DisableForeignKeys;
use Illuminate\Database\Seeder;

class WarehouseManagerPermissionSeeder extends Seeder
{
    use DisableForeignKeys;

    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $this->disableForeignKeys();

        $warehouse_manager = Role::query()
            ->where('id', 3) //warehouse manager
            ->first();

        $warehouse_permissions = null;
        for ($i = 35; $i <= 52; ++$i) {
            $warehouse_permissions[] = $i;
        }
        $total_permissions = array_merge([1, 120, 121], $warehouse_permissions);

        $warehouse_manager->permissions()->attach($total_permissions);


        $this->enableForeignKeys();
    }
}
